<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('email')->unique();
            $table->string('password');
            $table->string('country')->nullable();
            $table->string('phone',20)->nullable();
            $table->string('photo')->nullable();
            $table->tinyInteger('active_status')->default(1);
            $table->tinyInteger('role')->default(2);
            $table->string('email_verified',256)->default(0);
            $table->string('reset_code')->nullable()->unique();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('address')->nullable();
            $table->string('zip',20)->nullable();
            $table->string('device_id')->nullable();
            $table->string('language')->nullable();
            $table->tinyInteger('device_type')->default(1);
            $table->boolean('push_notification_status')->default(1);
            $table->boolean('email_notification_status')->default(1);
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
